varying highp vec2 TextureCoord;

uniform sampler2D Sampler;
uniform highp float Coefficients[5];
uniform highp vec2 Offset;
uniform highp vec2 secOffset;

void main(void)
{
    mediump vec3 A = Coefficients[0] * texture2D(Sampler, TextureCoord - secOffset).xyz;
    mediump vec3 B = Coefficients[1] * texture2D(Sampler, TextureCoord - Offset).xyz;
    mediump vec3 C = Coefficients[2] * texture2D(Sampler, TextureCoord).xyz;
    mediump vec3 D = Coefficients[3] * texture2D(Sampler, TextureCoord + Offset).xyz;
    mediump vec3 E = Coefficients[4] * texture2D(Sampler, TextureCoord + secOffset).xyz;
    mediump vec3 color = A + B + C + D + E;
    gl_FragColor = vec4(color, 1);
}